<?php

namespace ACA\EC;

use AC;
use AC\Plugin\Version;
use AC\PluginInformation;
use AC\Registrable;
use ACA\EC\ImportListscreens;
use ACA\EC\ListScreen;
use ACP\Storage\ListScreen\DecoderFactory;

final class EventsCalendar extends AC\Plugin {

	public function __construct( $file, Version $version ) {
		parent::__construct( $file, $version );
	}

	public function register() {
		$plugin_information = new PluginInformation( $this->get_basename() );
		$setup_factory = new AC\Plugin\SetupFactory( 'aca_events_calendar_version', $this->get_version() );

		$services = [
			new Service\ColumnGroups(),
			new Service\ListScreens( ),
			new Service\Scripts( $this->get_location() ),
			new Service\TableScreen( $this->get_location() ),
			new ImportListscreens\Message( new ImportListscreens\ImportedSetting() ),
			new ImportListscreens\Controller( new AC\Request(), AC()->get_storage(), new DecoderFactory( AC\ListScreenTypes::instance() ), $this->get_location() ),
			new AC\Service\Setup( $setup_factory->create( AC\Plugin\SetupFactory::SITE ) ),
		];

		if ( $plugin_information->is_network_active() ) {
			$services[] = new AC\Service\Setup( $setup_factory->create( AC\Plugin\SetupFactory::NETWORK ) );
		}

		array_map( [ $this, 'register_service' ], $services );
	}

	private function register_service( Registrable $service ) {
		$service->register();
	}

}