<?php

namespace ACA\BP\Service;

use AC;
use AC\Registrable;
use ACA\BP\Column\Profile;
use ReflectionException;

class Columns implements Registrable {

	public function register() {
		add_action( 'ac/column_groups', [ $this, 'register_column_groups' ] );
		add_action( 'acp/column_types', [ $this, 'register_columns' ] );
	}

	/**
	 * Add custom columns
	 *
	 * @param AC\ListScreen $list_screen
	 *
	 * @throws ReflectionException
	 */
	public function register_columns( AC\ListScreen $list_screen ) {
		if ( $list_screen instanceof AC\ListScreen\User ) {
			$list_screen->register_column_type( new Profile );
			$list_screen->register_column_types_from_dir( 'ACA\BP\Column\User' );
		}
	}

	/**
	 * @param AC\Groups $groups
	 */
	public function register_column_groups( AC\Groups $groups ) {
		$groups->register_group( 'buddypress', 'BuddyPress', 11 );
	}

}