<?php

namespace ACA\BP;

use AC;
use AC\Plugin\Version;
use AC\PluginInformation;
use AC\Registrable;
use ACA\BP\Service;

final class BuddyPress extends AC\Plugin {

	public function __construct( $file, Version $version ) {
		parent::__construct( $file, $version );
	}

	/**
	 * Register hooks
	 */
	public function register() {
		$plugin_information = new PluginInformation( $this->get_basename() );
		$setup_factory = new AC\Plugin\SetupFactory( 'aca_buddypress_version', $this->get_version() );

		$services = [
			new Service\Admin( $this->get_location() ),
			new Service\Columns(),
			new Service\ListScreens(),
			new Service\Table( $this->get_location() ),
			new AC\Service\Setup( $setup_factory->create( AC\Plugin\SetupFactory::SITE ) ),
		];

		if ( $plugin_information->is_network_active() ) {
			$services[] = new AC\Service\Setup( $setup_factory->create( AC\Plugin\SetupFactory::NETWORK ) );
		}

		array_map( [ $this, 'register_service' ], $services );
	}

	private function register_service( $service ) {
		if ( $service instanceof Registrable ) {
			$service->register();
		}
	}

}