<?php

namespace ACA\BP\Sorting\User;

use ACA\BP\Column;
use ACP;

/**
 * @property Column\User\ActivityUpdates $column
 */
class ActivityUpdates extends ACP\Sorting\Model {

	public function __construct( $column ) {
		parent::__construct( $column );
	}

	public function get_sorting_vars() {
		$sorting_vars = array(
			'ids' => $this->get_sorted_ids(),
		);

		return $sorting_vars;
	}

	private function get_sorted_ids() {
		global $wpdb, $bp;

		$where = '';
		$activity_type = $this->column->get_activity_type();

		if ( $activity_type ) {
			$where = $wpdb->prepare( "WHERE type = %s", $activity_type );
		}

		$sql = "SELECT user_id, COUNT(user_id) as activities
				FROM {$bp->activity->table_name}
				{$where}
				GROUP BY user_id
				ORDER BY activities " . $this->get_order();

		return (array) $wpdb->get_col( $sql );
	}

}