<?php

namespace ACA\BP\Sorting;

use ACA\BP\Column;
use ACP;

/**
 * @property Column\Profile $column
 */
class Profile extends ACP\Sorting\Model {

	public function __construct( Column\Profile $column ) {
		parent::__construct( $column );
	}

	public function get_sorting_vars() {
		$sorting_vars = array(
			'orderby' => $this->orderby,
			'ids'     => $this->get_sorted_ids(),
		);

		return $sorting_vars;
	}

	private function get_sorted_ids() {
		global $wpdb, $bp;

		$sql = $wpdb->prepare( "
					SELECT DISTINCT u.ID
					FROM {$wpdb->users} AS u
					INNER JOIN {$bp->profile->table_name_data} as bpd ON ( u.ID = bpd.user_id AND bpd.field_id = %d )
					ORDER BY bpd.value " . $wpdb->_real_escape( $this->get_order() ), $this->column->get_buddypress_field_id() );

		return (array) $wpdb->get_col( $sql );
	}

}