<?php

namespace ACA\BP\Filtering\Profile;

use ACA\BP\Filtering;

class Serialized extends Filtering\Profile {

	/**
	 * @param \WP_User_Query $query
	 */
	public function filter_by_callback( $query ) {
		global $wpdb;

		$where = $wpdb->prepare( "value LIKE %s", '%' . $wpdb->esc_like( serialize( $this->get_filter_value() ) ) . '%' );

		$this->add_sql_where( $query, $where );
	}

	public function get_filtering_data() {
		$options = array();

		foreach ( $this->get_xprofile_values() as $value ) {
			if ( is_serialized( $value ) ) {
				$options = array_merge( $options, unserialize( $value ) );
			}
		}

		$options = array_combine( $options, $options );

		return array(
			'empty_option' => true,
			'options'      => $options,
		);
	}

}