<?php

namespace ACA\BP\Field\Profile;

use ACA\BP\Editing;
use ACA\BP\Field\Profile;
use ACA\BP\Search;

class Radio extends Profile {

	public function editing() {
		return new Editing\Profile\Choices( $this->column, $this->get_options() );
	}

	public function search() {
		return new Search\Profile\Choice( $this->column->get_buddypress_field_id(), $this->get_options() );
	}

	private function get_options() {
		$options = array();
		foreach ( $this->column->get_buddypress_field()->get_children() as $option ) {
			$options[ $option->name ] = $option->name;
		}

		return $options;
	}

}