<?php

namespace ACA\BP\Editing\Profile;

use ACA\BP\Editing\Profile;
use BP_XProfile_ProfileData;

class Date extends Profile {

	public function get_view_settings() {
		$data = parent::get_view_settings();

		$data['type'] = 'date';
		$data['clear_button'] = ( ! $this->column->get_buddypress_field_option( 'is_required' ) );

		return $data;
	}

	public function get_edit_value( $id ) {
		$date = maybe_unserialize( BP_XProfile_ProfileData::get_value_byid( $this->column->get_buddypress_field_id(), $id ) );

		if ( ! $date ) {
			return false;
		}

		return date( 'Ymd', strtotime( $date ) );
	}

	/**
	 * @param int    $id
	 * @param string $value
	 *
	 * @return bool
	 */
	public function save( $id, $value ) {
		if ( $value ) {
			$value = date( 'Y-m-d H:i:s', strtotime( $value ) );
		}

		return parent::save( $id, $value );
	}

}