<?php

namespace ACA\BP\Editing\Group;

use ACP;

class Status extends ACP\Editing\Model {

	public function get_view_settings() {

		return array(
			'type'    => 'select',
			'options' => array(
				'public'  => __( 'Public', 'buddypress' ),
				'private' => __( 'Private', 'buddypress' ),
				'hidden'  => __( 'Hidden', 'buddypress' ),
			),
		);
	}

	/**
	 * @param int          $group_id
	 * @param array|string $value
	 *
	 * @return bool
	 */
	public function save( $group_id, $value ) {
		$group = groups_get_group( $group_id );

		$group->status = $value;

		return $group->save();
	}

}