<?php

namespace ACA\BP\Column\User;

use AC;
use ACA\BP\Filtering;
use ACP;

class Friends extends AC\Column\Meta
	implements ACP\Sorting\Sortable, ACP\Filtering\Filterable, ACP\Search\Searchable {

	public function __construct() {
		$this->set_type( 'column-buddypress_user_friends' )
		     ->set_label( __( 'Friends', 'buddypress' ) )
		     ->set_group( 'buddypress' );
	}

	public function get_meta_key() {
		return 'total_friend_count';
	}

	public function is_valid() {
		return bp_is_active( 'friends' );
	}

	public function get_raw_value( $id ) {
		return bp_get_total_friend_count( $id );
	}

	public function sorting() {
		return new ACP\Sorting\Model\Meta( $this );
	}

	public function search() {
		return new ACP\Search\Comparison\Meta\Numeric( $this->get_meta_key(), $this->get_meta_type() );
	}

	public function filtering() {
		return new Filtering\User\Friends( $this );
	}

}