<?php

namespace ACA\BP\Column\Group;

use AC;
use ACP;

class Creator extends AC\Column {

	public function __construct() {
		$this->set_type( 'column-group_creator' );
		$this->set_label( __( 'Creator', 'codepress-admin-columns' ) );
	}

	public function get_raw_value( $group_id ) {
		$group = groups_get_group( $group_id );

		return $group->creator_id;
	}

	public function register_settings() {
		$this->add_setting( new ACP\Settings\Column\User( $this ) );
	}

}