<?php

namespace ACA\BP;

use AC;
use ACA\BP\Editing\Ajax\EditableRows;
use ACA\BP\Editing\Ajax\TableRows;
use ACA\BP\ListScreen\Email;
use ACA\BP\ListScreen\Group;

final class BuddyPress extends AC\Plugin {

	/**
	 * @var string
	 */
	protected $file;

	public function __construct( $file ) {
		$this->file = $file;
	}

	/**
	 * Register hooks
	 */
	public function register() {
		add_action( 'ac/list_screen_groups', array( $this, 'register_list_screen_group' ) );
		add_action( 'ac/list_screens', array( $this, 'register_list_screens' ) );

		add_action( 'ac/column_groups', array( $this, 'register_column_groups' ) );
		add_action( 'acp/column_types', array( $this, 'register_columns' ) );

		add_action( 'ac/table/list_screen', array( $this, 'init_editable_table' ) );

		add_action( 'ac/table_scripts', array( $this, 'table_scripts' ), 1 );
	}

	private function is_bp_list_screen( $list_screen ) {
		return $list_screen instanceof Group ||
		       $list_screen instanceof Email;
	}

	/**
	 * @param AC\ListScreen $list_screen
	 */
	public function table_scripts( AC\ListScreen $list_screen ) {
		if ( ! $this->is_bp_list_screen( $list_screen ) ) {
			return;
		}

		wp_enqueue_script( 'aca-bp-table', ac_addon_buddypress()->get_url() . 'assets/js/table.js', array( 'jquery' ), ac_addon_buddypress()->get_version() );
		wp_enqueue_style( 'aca-bp-table', ac_addon_buddypress()->get_url() . 'assets/css/table.css', array(), ac_addon_buddypress()->get_version() );
	}

	/**
	 * @return string
	 */
	protected function get_file() {
		return $this->file;
	}

	/**
	 * @return string
	 */
	protected function get_version_key() {
		return 'aca_buddypress';
	}

	/**
	 * @param AC\AdminColumns $admin_columns
	 */
	public function register_list_screens( $admin_columns ) {
		$admin_columns->register_list_screen( new ListScreen\Email() )
		              ->register_list_screen( new ListScreen\Group() );
	}

	/**
	 * @param AC\Groups $groups
	 */
	public function register_list_screen_group( AC\Groups $groups ) {
		$groups->register_group( 'buddypress', __( 'BuddyPress' ), 14 );
	}

	/**
	 * @param AC\Groups $groups
	 */
	public function register_column_groups( AC\Groups $groups ) {
		$groups->register_group( 'buddypress', 'BuddyPress', 11 );
	}

	/**
	 * @param AC\ListScreen $list_screen
	 */
	public function init_editable_table( AC\ListScreen $list_screen ) {
		if ( ! $list_screen instanceof Group ) {
			return;
		}

		$table_rows = new TableRows\Groups( new AC\Request(), $list_screen );

		if ( $table_rows->is_request() ) {
			$table_rows->register();
		}

		$editable_rows = new EditableRows\Groups( new AC\Request(), $list_screen->editing() );

		if ( $editable_rows && $editable_rows->is_request() ) {
			$editable_rows->register();
		}
	}

	/**
	 * Add custom columns
	 *
	 * @param AC\ListScreen $list_screen
	 *
	 * @throws \ReflectionException
	 */
	public function register_columns( AC\ListScreen $list_screen ) {
		if ( $list_screen instanceof AC\ListScreen\User ) {
			$list_screen->register_column_type( new Column\Profile() );
			$list_screen->register_column_types_from_dir( 'ACA\BP\Column\User' );
		}
	}

}

