<?php
/*
Plugin Name:    Admin Columns Pro - BuddyPress
Version:        1.4
Description:    BuddyPress integration for Admin Columns
Author:         Admin Columns
Author URI:     https://www.admincolumns.com
Plugin URI:     https://www.admincolumns.com
Text Domain:    codepress-admin-columns
*/

use AC\Autoloader;
use ACA\BP\BuddyPress;
use ACA\BP\Dependencies;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! is_admin() ) {
	return;
}

require_once __DIR__ . '/classes/Dependencies.php';

add_action( 'after_setup_theme', function () {
	$dependencies = new Dependencies( plugin_basename( __FILE__ ), '1.4' );
	$dependencies->requires_acp( '4.5' );
	$dependencies->requires_php( '5.3.6' );

	if ( ! class_exists( 'BuddyPress', false ) ) {
		$dependencies->add_missing_plugin( __( 'BuddyPress', 'buddypress' ), $dependencies->get_search_url( 'BuddyPress' ) );
	}

	if ( $dependencies->has_missing() ) {
		return;
	}

	Autoloader::instance()->register_prefix( 'ACA\BP', __DIR__ . '/classes/' );

	$addon = new BuddyPress( __FILE__ );
	$addon->register();
} );

function ac_addon_buddypress() {
	return new BuddyPress( __FILE__ );
}